package com.maila88.modules.merchants.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.maila88.modules.merchants.dto.Maila88GoodsInboundRuleDto;

/**
 * 商品自动入库规则remote
 * Author: zhanghuifeng
 * Date:   11:49 2017/6/28
 */
@AdvancedFeignClient
public interface RemoteMaila88GoodsInboundRuleBackendService {

	/**
	 * 插入
	 * @param dto 数据
	 * @return boolean
	 */
	DubboResult<Boolean> insert(Maila88GoodsInboundRuleDto dto);

	/**
	 * 获取生效的规则
	 * @return 规则
	 */
	DubboResult<Maila88GoodsInboundRuleDto> findEffectiveRule();

	/**
	 * 获取失效的规则
	 * @return 规则
	 */
	DubboResult<Maila88GoodsInboundRuleDto> findDisabledRule();
}
