package com.maila88.modules.merchants.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.merchants.dto.Maila88MerchantsDto;
import com.maila88.modules.merchants.enums.Maila88VerifyStatusEnum;

/**
 * 管理员后台商家
 * Author: zhanghuifeng
 * Date:   17:49 2017/4/24
 */
@AdvancedFeignClient
public interface RemoteMaila88MerchantsBackendService {

	/**
	 * 查询所有商家信息
	 * @param account 账号
	 * @param contact 联系人
	 * @param offset   偏移量
	 * @param pageSize 每页数量
	 * @return 商家列表集
	 */
	DubboResult<Maila88PageDto<Maila88MerchantsDto>> findAllMerchantsPage(String account, String contact, Integer offset, Integer pageSize);

	/**
	 * 根据商家id查询商家信息
	 * @param merchantsIdList 商家id集合
	 * @return Map
	 */
	DubboResult<Map<Long, Maila88MerchantsDto>> findMerchantsByIds(List<Long> merchantsIdList);

	/**
	 * 根据商家id查询商家信息
	 * @param id 商家id
	 * @return Maila88MerchantsDto
	 */
	DubboResult<Maila88MerchantsDto> findMerchantById(Long id);

	/**
	 * 更新商家账号
	 * @param id      商家ID
	 * @param account 商家账号
	 * @return boolean
	 */
	DubboResult<Boolean> updateAccount(Long id, String account);

	/**
	 *
	 * @param id
	 * @param password
	 * @return
	 */
	DubboResult<Boolean> updatePasswordById(Long id, String password);

	/**
	 * 更新商家状态
	 * @param id           商家id
	 * @param verifyStatus 邮箱验证状态，0未验证 1已验证
	 * @return boolean
	 */
	DubboResult<Boolean> updateVerifyStatus(Long id, Maila88VerifyStatusEnum verifyStatus);

	/**
	 * 根据商家账号（邮箱）查询商家信息
	 * @param account 商家账号（邮箱）
	 * @return 商家信息
	 */
	DubboResult<Maila88MerchantsDto> findMerchant(String account);
}
