package com.maila88.modules.order.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by johnkeng on 2017/6/7.
 */
public class MailaAnormalOrdersDto implements Serializable{

    private static final long serialVersionUID = -7185237267322902964L;

    /**
     * 主键 id
     */
    private Long id;

    /**
     * 淘宝订单号
     */
    private Long tradeId;

    /**
     * 商品ID  num_iid
     */
    private Long itemId;

    /**
     * '0:未处理 1：已处理
     */
    private Integer processStatus;

    /**
     * 1:佣金比率错误 2:疑似刷单 12:佣金比率错误和疑似刷单
     */
    private Integer anormalType;

    /**
     * 处理人
     */
    private String processor;

    /**
     * 广告位ID
     */
    private Long adzoneId;

    /**
     * 订单创建时间
     */
    private Date createTime;

    /**
     * 订单结算时间
     */
    private Date earningTime;

    /**
     * 淘客订单状态，3：订单结算，12：订单付款， 13：订单失效，14：订单成功 对应tk_status
     */
    private Integer orderStatus;

    /**
     * 处理意见
     */
    private String note;

    /**
     * 商品数量
     */
    private Long itemNum;

    /**
     * 付款金额  原值*100
     */
    private Integer alipayTotalPrice;

    /**
     * 收入比率，卖家设置佣金比率+平台补贴比率 原值*100
     */
    private Integer incomeRate;

    /**
     * 最终收入比率，卖家设置佣金比率+平台补贴比率 原值*10000
     */
    private Integer goodsIncomeRate;

    /**
     * 商品标题
     */
    private String itemTitle;

    /**
     * 卖家昵称
     */
    private String sellerNick;

    /**
     * 卖家店铺名称
     */
    private String sellerShopTitle;

    /**
     * 创建时间'
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTradeId() {
        return tradeId;
    }

    public void setTradeId(Long tradeId) {
        this.tradeId = tradeId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getProcessStatus() {
        return processStatus;
    }

    public void setProcessStatus(Integer processStatus) {
        this.processStatus = processStatus;
    }

    public Integer getAnormalType() {
        return anormalType;
    }

    public void setAnormalType(Integer anormalType) {
        this.anormalType = anormalType;
    }

    public String getProcessor() {
        return processor;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public Long getAdzoneId() {
        return adzoneId;
    }

    public void setAdzoneId(Long adzoneId) {
        this.adzoneId = adzoneId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getEarningTime() {
        return earningTime;
    }

    public void setEarningTime(Date earningTime) {
        this.earningTime = earningTime;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Long getItemNum() {
        return itemNum;
    }

    public void setItemNum(Long itemNum) {
        this.itemNum = itemNum;
    }

    public Integer getAlipayTotalPrice() {
        return alipayTotalPrice;
    }

    public void setAlipayTotalPrice(Integer alipayTotalPrice) {
        this.alipayTotalPrice = alipayTotalPrice;
    }

    public Integer getIncomeRate() {
        return incomeRate;
    }

    public void setIncomeRate(Integer incomeRate) {
        this.incomeRate = incomeRate;
    }

    public Integer getGoodsIncomeRate() {
        return goodsIncomeRate;
    }

    public void setGoodsIncomeRate(Integer goodsIncomeRate) {
        this.goodsIncomeRate = goodsIncomeRate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getItemTitle() {
        return itemTitle;
    }

    public void setItemTitle(String itemTitle) {
        this.itemTitle = itemTitle;
    }

    public String getSellerNick() {
        return sellerNick;
    }

    public void setSellerNick(String sellerNick) {
        this.sellerNick = sellerNick;
    }

    public String getSellerShopTitle() {
        return sellerShopTitle;
    }

    public void setSellerShopTitle(String sellerShopTitle) {
        this.sellerShopTitle = sellerShopTitle;
    }
}
