package com.maila88.modules.rob.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.common.dto.Maila88SelectDto;
import com.maila88.modules.rob.dto.Maila88RobGoodsDto;
import com.maila88.modules.rob.dto.Maila88RobGoodsEditDetailDto;
import com.maila88.modules.rob.dto.Maila88RobGoodsPageDto;
import com.maila88.modules.rob.dto.Maila88RobGoodsSelectDto;
import com.maila88.modules.rob.params.Maila88RobGoodsQueryParam;

import java.util.List;

/**
 *
 * Created by peanuthuang on 2017/5/3.
 */
@AdvancedFeignClient
public interface RemoteMaila88RobGoodsBackendService {

    /**
     * 新增抢购商品
     *
     * @param maila88RobGoodsDto 实体dto
     * @return 返回数据入库后的记录id
     */
    DubboResult<Long> insert(Maila88RobGoodsDto maila88RobGoodsDto);

    /**
     * 更新抢购商品
     *
     * @param maila88RobGoodsDto 实体dto
     * @return
     */
    DubboResult<Boolean> update(Maila88RobGoodsDto maila88RobGoodsDto);

    /**
     * 删除抢购商品
     *
     * @param goodsId
     * @return
     */
    DubboResult<Boolean> delete(Long goodsId);

    /**
     * 抢购商品
     *
     * @param goodsId 实体dto
     * @return
     */
    DubboResult<Maila88RobGoodsDto> findByGoodsId(Long goodsId);

    /**
     * 分页查询抢购商品
     *
     * @param robGoodsQryParam 查询参数
     * @return
     */
    DubboResult<Maila88PageDto<Maila88RobGoodsPageDto>> find4Page(Maila88RobGoodsQueryParam robGoodsQryParam);

    /**
     * 根据id或者名称查询待生效或已生效的优惠券商品列表
     *
     * @param idOrName
     * @return
     */
    DubboResult<List<Maila88RobGoodsSelectDto>> findUndisableCouponGoods(String idOrName);

    /**
     * 根据 id 或者名称查询待生效或者已生效的优惠券商品列表
     * @param idOrName
     * @param sceneId
     * @return
     */
    DubboResult<List<Maila88SelectDto>> findUndisableRobGoods(String idOrName, Long sceneId);

    /**
     * 根据 goodsid 获取抢购商品的详情
     * @param goodsId
     * @return
     */
    DubboResult<Maila88RobGoodsEditDetailDto> findRobGoodsDetailByGoodsId(Long goodsId);
}
