package com.maila88.modules.rob.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

import com.maila88.modules.rob.dto.Maila88RobGoodsDetailDto;

/**
 * 手机端抢购商品
 * Author: zhanghuifeng
 * Date:   14:09 2017/5/3
 */
@AdvancedFeignClient
public interface RemoteMaila88RobGoodsService {

	/**
	 * 根据场次ID获取商品
	 * @param sceneId 场次ID
	 * @param lastPayload 分页时传递当前页面最后一条数据的排序号码
	 * @param  pageSize 每页条数
	 * @return 商品详情
	 */
	DubboResult<List<Maila88RobGoodsDetailDto>> findBySceneId(Long sceneId, Integer lastPayload, Integer pageSize);

	/**
	 * 根据商品ID查询商品详情
	 * @param goodsId 商品ID
	 * @return 商品详情
	 */
	DubboResult<Maila88RobGoodsDetailDto> findByGoodsId(Long goodsId);

	/**
	 * 根据商品ID更新抢购商品pv
	 * @param goodsId 商品ID
	 * @param goodsPv 点击pv
	 * @return boolean
	 */
	DubboResult<Boolean> updateGoodsPv(Long goodsId, Long goodsPv);

	/**
	 * 获取抢购商品点击pv
	 * @param goodsId 商品ID
	 * @return 点击pv
	 */
	DubboResult<Long> findGoodsPv(Long goodsId);
}

