package com.maila88.modules.skin.enums;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by peanuthuang on 2017/5/10.
 */
public enum Maila88SKinTypeEnum {

    MAILA_INDEX(1, "麦啦首页"),
    MAILA_SPECIAL(2, "麦啦专场"),
    DUIBA_INDEX(3, "兑吧首页"),
    DUIBA_SPECIAL(4, "兑吧专场"),
    ROB_INDEX(5,"抢购首页皮肤"),
    ROB_DETAIL(6,"抢购详情页皮肤"),
    SEARCH_DETAIL(7,"搜索详情页皮肤"),
    WX_GOODS_DETAIL(8,"微信商品详情页"),
    GUESS_LIKE_INDEX(9,"猜你喜欢详情页"),
    ROB_GOODS_DETAIL(10,"今日必抢商品详情页"),
    JQG_APP_INDEX(11,"聚钱购app皮肤"),
    WEI_SEARCH_RESULT(12,"微淘客搜索结果页"),
    SEARCH_TAO_COMMAND_DETAIL(13,"搜索-淘口令详情页");

    private int id;
    private String name;

    Maila88SKinTypeEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    /**
     * 根据id 查询
     *
     * @param id
     * @return
     */
    public static Maila88SKinTypeEnum findTypeById(int id) {
        for (Maila88SKinTypeEnum skinTypeEnum : Maila88SKinTypeEnum.values()) {
            if (skinTypeEnum.getId() == id) {
                return skinTypeEnum;
            }
        }
        return null;
    }

    /**
     * 存入map
     *
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}


