package com.maila88.modules.special.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.app.enums.Maila88DevTypeEnum;
import com.maila88.modules.special.dto.Maila88AppSpecialGoodsDto;
import com.maila88.modules.special.dto.Maila88SpecialDto;

import java.util.List;

/**
 * Created by sunchangji on 2017/6/28.
 */
@AdvancedFeignClient
public interface RemoteMaila88SpecialService {

    /**
     * 根据应用id和专场id查询专场下所有商品
     * @param appId 应用id
     * @param specialId 专场id
     * @return
     */
    DubboResult<List<Maila88AppSpecialGoodsDto>> findAppGoodsByAppIdAndSpecialId(Long appId, Long specialId);

    /**
     * 获取专场排期结束时间
     *
     * @param appId     应用id
     * @param specialId 专场id
     * @return 排期结束时间的毫秒数:专场开关为ON:毫秒数，OFF:null
     */
    DubboResult<Long> findSpecialScheduleEndTime(Long appId, Long specialId);

    /**
     * 获取专场皮肤ID
     * @param specialId  专场ID
     * @param devType 开发者应用类型
     * @return Long
     */
    DubboResult<Long> findSpecialSkinId(Long specialId, Maila88DevTypeEnum devType);

    /**
     * 根据专场id获取专场
     *
     * @param specialId  专场id
     * @return
     */
    DubboResult<Maila88SpecialDto> findById(Long specialId);
}
