package com.maila88.modules.tab.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 麦啦tab内容排序方式
 * Created by peanut.huang on 2017/8/2.
 */
public enum Maila88TabContentSortType {

    DEFAULT("df","默认排序"),

    PRICE_UP("pu","价格从低到高"),
    PRICE_DOWN("pd","价格从高到低"),

    VOLUME_UP("vu","销量从低到高"),
    VOLUME_DOWN("vd","销量从高到低");


    private String value;

    private String desc;

    Maila88TabContentSortType(String value,String desc){
        this.desc = desc;
        this.value = value;
    }

    /**
     * 根据类型值查找
     *
     * @param value
     * @return
     */
    public static Maila88TabContentSortType findByValue(String value){
        if(StringUtils.isBlank(value)){
            return null;
        }
        return Arrays.stream(Maila88TabContentSortType.values()).filter(n -> n.getValue().equals(value)).findFirst().orElse(null);
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
