package com.maila88.modules.tab.enums;

import java.util.Arrays;

/**
 * Created by peanut.huang on 2017/6/20.
 */
public enum Maila88TabType {

    ORDINARY(0,"普通"),
    WHOLE(1,"全部"),
    CATEGORY(2,"类目tab"),
    PUBLIC_TAB(3,"公共tab");

    private int id;

    private String desc;

    Maila88TabType(int id,String desc){
        this.desc = desc;
        this.id = id;
    }

    /**
     * 根据类型值查找
     *
     * @param id
     * @return
     */
    public static Maila88TabType findById(Integer id){
        if(id == null){
            return null;
        }
       return Arrays.stream(Maila88TabType.values()).filter(n -> n.getId() == id).findFirst().orElse(null);
    }

    public int getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }
}
