package com.maila88.modules.tag.enums;

import java.util.Arrays;

/**
 * 麦啦标签属性关联枚举
 *
 * Created by peanut.huang on 2017/8/18.
 */
public enum Maila88TagPropertyEnum {

    TAG_TYPE(1,"标签类别"),

    TAG_KEYWORD(2,"标签关键字");

    private int id;

    private String desc;

    Maila88TagPropertyEnum(int id,String desc){
        this.id = id;
        this.desc = desc;
    }

    /**
     * 根据id值查找
     *
     * @param id
     * @return
     */
    public static Maila88TagPropertyEnum findById(Integer id){
        if(id == null || id <= 0){
            return null;
        }
        return Arrays.stream(Maila88TagPropertyEnum.values()).filter(n -> n.getId() == id).findFirst().orElse(null);
    }

    public int getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }
}
