package com.maila88.modules.tag.enums;

import java.util.Arrays;

/**
 * 标签引用关系类型枚举
 *
 * Created by peanut.huang on 2017/8/22.
 */
public enum Maila88TagReferenceTypeEnum {

    TAG_REF_GOODS(1,"商品");

    private int id;

    private String desc;

    Maila88TagReferenceTypeEnum(int id,String desc){
        this.id = id;
        this.desc = desc;
    }

    /**
     * 根据id值查找
     *
     * @param id
     * @return
     */
    public static Maila88TagReferenceTypeEnum findById(Integer id){
        if(id == null || id <= 0){
            return null;
        }
        return Arrays.stream(Maila88TagReferenceTypeEnum.values()).filter(n -> n.getId() == id).findFirst().orElse(null);
    }

    public int getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }
}
