package com.maila88.modules.tag.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88BusinessMsgDto;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.tag.dto.Maila88TagDto;

/**
 * 麦啦标签后台服务
 *
 * Created by peanut.huang on 2017/8/18.
 */
@AdvancedFeignClient
public interface RemoteMaila88TagBackendService {

    /**
     * 标签分页列表
     *
     * @param pageNum
     * @param pageSize
     * @return
     */
    DubboResult<Maila88PageDto<Maila88TagDto>> listPageTags(Integer pageNum, Integer pageSize);

    /**
     * 添加标签
     *
     * @param tagDto
     * @return
     */
    DubboResult<Maila88BusinessMsgDto> addTag(Maila88TagDto tagDto);


    /**
     * 更新标签
     *
     * @param tagDto
     * @return
     */
    DubboResult<Maila88BusinessMsgDto> updateTag(Maila88TagDto tagDto);


    /**
     * 删除标签
     *
     * @param tagId
     * @return
     */
    DubboResult<Boolean> deleteTag(Long tagId);

    /**
     * 删除商品的某个标签
     *
     * @param tagName
     * @param goodsId
     * @return
     */
    DubboResult<Maila88BusinessMsgDto> deleteGoodsTag(String tagName, Long goodsId);

    /**
     * 根据标签id获取
     *
     * @param tagId
     * @return
     */
    DubboResult<Maila88TagDto> findById(Long tagId);

    /**
     * 根据名称查询
     *
     * @param tagName
     * @return
     */
    DubboResult<Maila88TagDto> findByTagName(String tagName);

    /**
     * 订正便签和规则数据
     * @return boolean
     */
    Boolean repairTagRule();
}
