/*
 * Decompiled with CFR 0.152.
 */
package com.maila88.common.tools;

import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base58 {
    private static final Logger LOGGER;
    private static final char[] ALPHABET;
    private static final int[] INDEXES;

    private Base58() {
        throw new IllegalStateException("Base58 class not new");
    }

    public static String encode(byte[] input) {
        int zeroCount;
        if (input.length == 0) {
            return "";
        }
        byte[] newInput = Base58.copyOfRange(input, 0, input.length);
        for (zeroCount = 0; zeroCount < newInput.length && newInput[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[newInput.length * 2];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < newInput.length) {
            byte mod = Base58.divmod58(newInput, startAt);
            if (newInput[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = (byte)ALPHABET[mod];
        }
        while (j < temp.length && temp[j] == ALPHABET[0]) {
            ++j;
        }
        while (--zeroCount >= 0) {
            temp[--j] = (byte)ALPHABET[0];
        }
        byte[] output = Base58.copyOfRange(temp, j, temp.length);
        try {
            return new String(output, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Base58 encode error", (Throwable)e);
            return "";
        }
    }

    private static byte divmod58(byte[] number, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number.length; ++i) {
            int digit256 = number[i] & 0xFF;
            int temp = remainder * 256 + digit256;
            number[i] = (byte)(temp / 58);
            remainder = temp % 58;
        }
        return (byte)remainder;
    }

    private static byte[] copyOfRange(byte[] source, int from, int to) {
        byte[] range = new byte[to - from];
        System.arraycopy(source, from, range, 0, range.length);
        return range;
    }

    static {
        int i;
        LOGGER = LoggerFactory.getLogger(Base58.class);
        ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
        INDEXES = new int[128];
        for (i = 0; i < INDEXES.length; ++i) {
            Base58.INDEXES[i] = -1;
        }
        for (i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

