package com.maila.biz.center.api.constants;

/**
 * 后台管理常量类
 * <p>
 * ClassName:Constants
 * Date     : 2016年11月03日 10:51:27
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public class ManagerConstants {

    /**
     * 后台管理默认每页最大数据量
     */
    public static final Integer MANAGER_DEFAULT_MAX_PAGE_SIZE = 20;

    /**
     * 商品主图阿里云Cdn域名地址
     */
    public static final String ALIYUN_CDN_HOST = "//img.alicdn.com";

    /**
     * 截取淘宝商品主图图片大小
     */
    public static final String TAOBAO_IMG_SIZE = "_200x200.jpg";

    /**
     * 淘宝订单展示图片大小
     */
    public static final String TAOBAO_ORDER_IMG_SIZE = "_110x110.jpg";

    /**
     * 邮箱正则
     */
    public static final String EMAIL_RULE = "^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$";

    /**
     * 兑吧类型应用duiba_app_info字段json中独立运营开关(1:开启,0关闭，默认设置0)key
     */
    public static final String DUIBA_INDEP_OPERATION = "indep_operation";

    /**
     * 兑吧类型应用duiba_app_info字段json中积分价值key
     */
    public static final String CREDITS = "credits";

    /**
     * 兑吧类型应用duiba_app_info字段json中积分价值类型key
     */
    public static final String CREDITS_TYPE = "creditsType";

    /**
     * 私有构造方法
     */
    private ManagerConstants() {
    }

}
