package com.maila.biz.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 麦啦管理员后台商家店铺dto
 *
 * @ClassName MailaShopsDto
 * @Author zhanghuifeng
 * @Date 14:41 2016/11/28
 */
public class MailaShopDto implements Serializable {

	private static final long serialVersionUID = 4695121869175648880L;

	/**
	 * 主键id
	 */
	private Long id;

	/**
	 * 商家id
	 */
	private Long merchantsId;

	/**
	 * 商家账号
	 */
	private String merchantAccount;
	/**
	 * 商家运营旺旺
	 */
	private String merchantWangwang;

	/**
	 * 商家联系人
	 */
	private String merchantContact;

	/**
	 * 商家联系手机
	 */
	private String merchantPhone;

	/**
	 * 商家qq号
	 */
	private String merchantQq;

	/**
	 * 店铺名称
	 */
	private String shopName;

	/**
	 * 店铺链接
	 */
	private String shopUrl;

	/**
	 * 掌柜名称
	 */
	private String shopKeeper;

	/**
	 * 店铺类型 @See MailaShopType
	 */
	private Integer shopType;

	/**
	 * 店铺类型中文值 @See MailaShopType
	 */
	private String shopTypeValue;

	/**
	 * 主营类目 @See MailaShopCommodityType
	 */
	private Integer commodityType;

	/**
	 * 主营类目中文值 @See MailaShopCommodityType
	 */
	private String commodityTypeValue;

	/**
	 * 阿里旺旺
	 */
	private String wangwang;

	/**
	 * 审核状态：0:待审核,-1:审核未通过
	 */
	private Integer auditStatus;

	/**
	 * 审核状态值：0:待审核,-1:审核未通过
	 */
	private String auditStatusValue;

	/**
	 * 拒绝原因
	 */
	private String refuseMsg;

	/**
	 * 排序时间
	 */
	private Date sortTime;

	/**
	 * 创建时间
	 */
	private Date gmtCreate;

	/**
	 * 更新时间
	 */
	private Date gmtModified;

	/**
	 * 店铺冻结开始时间
	 */
	private Date frozenStartTime;

	/**
	 * 店铺冻结结束时间
	 */
	private Date frozenEndTime;

	/**
	 * 审核人
	 */
	private String auditor;

	/**
	 * 构造方法
	 */
	public MailaShopDto() {
		super();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getMerchantsId() {
		return merchantsId;
	}

	public void setMerchantsId(Long merchantsId) {
		this.merchantsId = merchantsId;
	}

	public String getShopName() {
		return shopName;
	}

	public void setShopName(String shopName) {
		this.shopName = shopName;
	}

	public String getShopUrl() {
		return shopUrl;
	}

	public void setShopUrl(String shopUrl) {
		this.shopUrl = shopUrl;
	}

	public String getShopKeeper() {
		return shopKeeper;
	}

	public void setShopKeeper(String shopKeeper) {
		this.shopKeeper = shopKeeper;
	}

	public Integer getShopType() {
		return shopType;
	}

	public void setShopType(Integer shopType) {
		this.shopType = shopType;
	}

	public String getShopTypeValue() {
		return shopTypeValue;
	}

	public void setShopTypeValue(String shopTypeValue) {
		this.shopTypeValue = shopTypeValue;
	}

	public Integer getCommodityType() {
		return commodityType;
	}

	public void setCommodityType(Integer commodityType) {
		this.commodityType = commodityType;
	}

	public String getCommodityTypeValue() {
		return commodityTypeValue;
	}

	public void setCommodityTypeValue(String commodityTypeValue) {
		this.commodityTypeValue = commodityTypeValue;
	}

	public String getWangwang() {
		return wangwang;
	}

	public void setWangwang(String wangwang) {
		this.wangwang = wangwang;
	}

	public Integer getAuditStatus() {
		return auditStatus;
	}

	public void setAuditStatus(Integer auditStatus) {
		this.auditStatus = auditStatus;
	}

	public String getAuditStatusValue() {
		return auditStatusValue;
	}

	public void setAuditStatusValue(String auditStatusValue) {
		this.auditStatusValue = auditStatusValue;
	}

	public String getRefuseMsg() {
		return refuseMsg;
	}

	public void setRefuseMsg(String refuseMsg) {
		this.refuseMsg = refuseMsg;
	}

	public Date getSortTime() {
		return sortTime;
	}

	public void setSortTime(Date sortTime) {
		this.sortTime = sortTime;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Date getFrozenStartTime() {
		return frozenStartTime;
	}

	public void setFrozenStartTime(Date frozenStartTime) {
		this.frozenStartTime = frozenStartTime;
	}

	public Date getFrozenEndTime() {
		return frozenEndTime;
	}

	public void setFrozenEndTime(Date frozenEndTime) {
		this.frozenEndTime = frozenEndTime;
	}

	public String getMerchantAccount() {
		return merchantAccount;
	}

	public void setMerchantAccount(String merchantAccount) {
		this.merchantAccount = merchantAccount;
	}

	public String getMerchantWangwang() {
		return merchantWangwang;
	}

	public void setMerchantWangwang(String merchantWangwang) {
		this.merchantWangwang = merchantWangwang;
	}

	public String getMerchantContact() {
		return merchantContact;
	}

	public void setMerchantContact(String merchantContact) {
		this.merchantContact = merchantContact;
	}

	public String getMerchantPhone() {
		return merchantPhone;
	}

	public void setMerchantPhone(String merchantPhone) {
		this.merchantPhone = merchantPhone;
	}

	public String getMerchantQq() {
		return merchantQq;
	}

	public void setMerchantQq(String merchantQq) {
		this.merchantQq = merchantQq;
	}

	public String getAuditor() {
		return auditor;
	}

	public void setAuditor(String auditor) {
		this.auditor = auditor;
	}
}
