package com.maila.biz.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能描述:用于商家后台的店铺信息DTO对象
 *
 * @author sunchangji
 * @date 2016/12/9
 */
public class MailaShopPlatformDto implements Serializable {
	private static final long serialVersionUID = 6309642931265189039L;
	/**
	 * 主键(店铺id)
	 */
	private Long id;
	/**
	 * 商家id
	 */
	private Long merchantsId;
	/**
	 * 店铺名称
	 */
	private String shopName;
	/**
	 * 店铺链接
	 */
	private String shopUrl;
	/**
	 * 掌柜名
	 */
	private String shopKeeper;
	/**
	 * 店铺类型(参考MailaShopType类)
	 */
	private Integer shopType;
	/**
	 * 主营类目 参看MailaShopCommodityType
	 */
	private Integer commodityType;
	/**
	 * 店铺旺旺号
	 */
	private String wangwang;
	/**
	 * 店铺冻结开始时间
	 */
	private Date frozenStartTime;
	/**
	 * 店铺冻结结束时间
	 */
	private Date frozenEndTime;


	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getMerchantsId() {
		return merchantsId;
	}

	public void setMerchantsId(Long merchantsId) {
		this.merchantsId = merchantsId;
	}

	public String getShopName() {
		return shopName;
	}

	public void setShopName(String shopName) {
		this.shopName = shopName;
	}

	public String getShopUrl() {
		return shopUrl;
	}

	public void setShopUrl(String shopUrl) {
		this.shopUrl = shopUrl;
	}

	public String getShopKeeper() {
		return shopKeeper;
	}

	public void setShopKeeper(String shopKeeper) {
		this.shopKeeper = shopKeeper;
	}

	public Integer getShopType() {
		return shopType;
	}

	public void setShopType(Integer shopType) {
		this.shopType = shopType;
	}

	public Integer getCommodityType() {
		return commodityType;
	}

	public void setCommodityType(Integer commodityType) {
		this.commodityType = commodityType;
	}

	public String getWangwang() {
		return wangwang;
	}

	public void setWangwang(String wangwang) {
		this.wangwang = wangwang;
	}

	public Date getFrozenStartTime() {
		return frozenStartTime;
	}

	public void setFrozenStartTime(Date frozenStartTime) {
		this.frozenStartTime = frozenStartTime;
	}

	public Date getFrozenEndTime() {
		return frozenEndTime;
	}

	public void setFrozenEndTime(Date frozenEndTime) {
		this.frozenEndTime = frozenEndTime;
	}
}
