package com.maila.biz.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by johnkeng on 2017/4/6.
 */
public class MailaThirdpartyOrdersDto implements Serializable{

    private static final long serialVersionUID = -1739076078826686324L;

    /**
     * 主键 id
     */
    private Long id;

    /**
     * 淘宝父订单号
     */
    private Long tradeParentId;

    /**
     * 淘宝订单号
     */
    private Long tradeId;

    /**
     * 商品ID  num_iid
     */
    private Long itemId;

    /**
     * 商品标题
     */
    private String itemTitle;

    /**
     * 商品数量
     */
    private Long itemNum;

    /**
     * 单价 原值*100
     */
    private Integer price;

    /**
     * 实际支付金额 原值*100
     */
    private Integer payPrice;

    /**
     * 卖家昵称
     */
    private String sellerNick;

    /**
     * 卖家店铺名称
     */
    private String sellerShopTitle;

    /**
     * 推广者获得的收入金额，对应联盟后台报表“预估收入” 原值*100
     */
    private Integer commission;

    /**
     * 推广者获得的分成比率，对应联盟后台报表“分成比率” 比如 1.0000 原值*10000
     */
    private Integer commissionRate;

    /**
     * 订单创建时间
     */
    private Date createTime;

    /**
     * 订单结算时间
     */
    private Date earningTime;

    /**
     * 淘客订单状态，3：订单结算，12：订单付款， 13：订单失效，14：订单成功 对应tk_status
     */
    private Integer orderStatus;

    /**
     * 第三方服务来源，没有第三方服务，取值为“--”
     */
    private String tk3rdType;

    /**
     * 第三方推广者ID
     */
    private Long tk3rdPubId;

    /**
     * 订单类型，如1:天猫，2:淘宝
     */
    private Integer orderType;

    /**
     * 收入比率，卖家设置佣金比率+平台补贴比率 原值*10000
     */
    private Integer incomeRate;

    /**
     * 效果预估，付款金额*(佣金比率+补贴比率)*分成比率 原值*100
     */
    private Integer pubSharePreFee;

    /**
     * 补贴比率 原值*10000
     */
    private Integer subsidyRate;

    /**
     * 补贴类型，天猫:1，聚划算:2，航旅:3，阿里云:4  -1(估计是没有)
     */
    private Integer subsidyType;

    /**
     * 成交平台，PC:1，无线:2
     */
    private Integer terminalType;

    /**
     * 类目名称 如 办公设备/耗材
     */
    private String auctionCategory;

    /**
     * 来源媒体ID
     */
    private Long siteId;

    /**
     * 来源媒体名称
     */
    private String siteName;

    /**
     * 广告位ID
     */
    private Long adzoneId;

    /**
     * 广告位名称
     */
    private String adzoneName;

    /**
     * 付款金额  原值*100
     */
    private Integer alipayTotalPrice;

    /**
     * 佣金比率 原值*10000
     */
    private Integer totalCommissionRate;

    /**
     * 佣金金额 原值*100
     */
    private Integer totalCommissionFee;

    /**
     * 补贴金额 原值*100
     */
    private Integer subsidyFee;

    /**
     * 商品来源 0表示第三方、大淘客 1表示自主招商 2无法确认
     */
    private Integer merchantsType;

    /**
     * 订单所属类目类别
     */
    private Integer category;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTradeParentId() {
        return tradeParentId;
    }

    public void setTradeParentId(Long tradeParentId) {
        this.tradeParentId = tradeParentId;
    }

    public Long getTradeId() {
        return tradeId;
    }

    public void setTradeId(Long tradeId) {
        this.tradeId = tradeId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemTitle() {
        return itemTitle;
    }

    public void setItemTitle(String itemTitle) {
        this.itemTitle = itemTitle;
    }

    public Long getItemNum() {
        return itemNum;
    }

    public void setItemNum(Long itemNum) {
        this.itemNum = itemNum;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Integer getPayPrice() {
        return payPrice;
    }

    public void setPayPrice(Integer payPrice) {
        this.payPrice = payPrice;
    }

    public String getSellerNick() {
        return sellerNick;
    }

    public void setSellerNick(String sellerNick) {
        this.sellerNick = sellerNick;
    }

    public String getSellerShopTitle() {
        return sellerShopTitle;
    }

    public void setSellerShopTitle(String sellerShopTitle) {
        this.sellerShopTitle = sellerShopTitle;
    }

    public Integer getCommission() {
        return commission;
    }

    public void setCommission(Integer commission) {
        this.commission = commission;
    }

    public Integer getCommissionRate() {
        return commissionRate;
    }

    public void setCommissionRate(Integer commissionRate) {
        this.commissionRate = commissionRate;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getEarningTime() {
        return earningTime;
    }

    public void setEarningTime(Date earningTime) {
        this.earningTime = earningTime;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getTk3rdType() {
        return tk3rdType;
    }

    public void setTk3rdType(String tk3rdType) {
        this.tk3rdType = tk3rdType;
    }

    public Long getTk3rdPubId() {
        return tk3rdPubId;
    }

    public void setTk3rdPubId(Long tk3rdPubId) {
        this.tk3rdPubId = tk3rdPubId;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public Integer getIncomeRate() {
        return incomeRate;
    }

    public void setIncomeRate(Integer incomeRate) {
        this.incomeRate = incomeRate;
    }

    public Integer getPubSharePreFee() {
        return pubSharePreFee;
    }

    public void setPubSharePreFee(Integer pubSharePreFee) {
        this.pubSharePreFee = pubSharePreFee;
    }

    public Integer getSubsidyRate() {
        return subsidyRate;
    }

    public void setSubsidyRate(Integer subsidyRate) {
        this.subsidyRate = subsidyRate;
    }

    public Integer getSubsidyType() {
        return subsidyType;
    }

    public void setSubsidyType(Integer subsidyType) {
        this.subsidyType = subsidyType;
    }

    public Integer getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(Integer terminalType) {
        this.terminalType = terminalType;
    }

    public String getAuctionCategory() {
        return auctionCategory;
    }

    public void setAuctionCategory(String auctionCategory) {
        this.auctionCategory = auctionCategory;
    }

    public Long getSiteId() {
        return siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public String getSiteName() {
        return siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public Long getAdzoneId() {
        return adzoneId;
    }

    public void setAdzoneId(Long adzoneId) {
        this.adzoneId = adzoneId;
    }

    public String getAdzoneName() {
        return adzoneName;
    }

    public void setAdzoneName(String adzoneName) {
        this.adzoneName = adzoneName;
    }

    public Integer getAlipayTotalPrice() {
        return alipayTotalPrice;
    }

    public void setAlipayTotalPrice(Integer alipayTotalPrice) {
        this.alipayTotalPrice = alipayTotalPrice;
    }

    public Integer getTotalCommissionRate() {
        return totalCommissionRate;
    }

    public void setTotalCommissionRate(Integer totalCommissionRate) {
        this.totalCommissionRate = totalCommissionRate;
    }

    public Integer getTotalCommissionFee() {
        return totalCommissionFee;
    }

    public void setTotalCommissionFee(Integer totalCommissionFee) {
        this.totalCommissionFee = totalCommissionFee;
    }

    public Integer getSubsidyFee() {
        return subsidyFee;
    }

    public void setSubsidyFee(Integer subsidyFee) {
        this.subsidyFee = subsidyFee;
    }

    public Integer getMerchantsType() {
        return merchantsType;
    }

    public void setMerchantsType(Integer merchantsType) {
        this.merchantsType = merchantsType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getCategory() {
        return category;
    }

    public void setCategory(Integer category) {
        this.category = category;
    }
}
