package com.maila.biz.center.api.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * ClassName:AdminAuth
 * Date     : 2016年11月17日 10:49:18
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public enum AdminAuth {
    SUPER(0, "超级管理员"), NORMAL(1, "管理员");

    private int id;
    private String name;

    AdminAuth(int id, String name) {
        this.id = id;
        this.name = name;
    }

    /**
     * @param id
     * @return
     */
    public static String getNameById(final int id) {
        Collection<AdminAuth> result = Collections2.filter(Arrays.asList(AdminAuth.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? null : result.iterator().next().getName();
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

}
