package com.maila.biz.center.api.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * 麦啦商品或专场状态
 * <p>
 * ClassName:GoodsSpecialStatus
 * Date     : 2016年11月02日 17:06:55
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public enum GoodsSpecialStatus {
    //已失效是手动失效,自动失效是已结束
    READY(0, "待生效"), ON_SALE(1, "已生效"), OFF_SALE(-1, "已失效"),INVALID(-2,"手动失效"),AUTO_INVALID(-3,"系统下架");

    private int id;
    private String name;

    GoodsSpecialStatus(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }


    /**
     * 根据id获取名称
     *
     * @param id
     * @return
     */
    public static String getNameById(final int id) {
        Collection<GoodsSpecialStatus> result = Collections2.filter(Arrays.asList(GoodsSpecialStatus.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }

	/**
     * 存入map
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}
