package com.maila.biz.center.api.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * 麦啦发送的邮件类型
 * <p>
 * ClassName:MailaEmailType
 * Date     : 2016年11月25日 18:34:47
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public enum MailaEmailType {
    SIGN(0, "注册"),
    RESET(1, "重置密码");

    private int id;
    private String name;

    MailaEmailType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }


    /**
     * 根据类型获取
     *
     * @param type 类型:SING,RESET
     * @return
     */
    public static MailaEmailType getByType(final String type) {
        Collection<MailaEmailType> result = Collections2.filter(Arrays.asList(MailaEmailType.values()), gs -> gs.toString().equals(type));
        return result.isEmpty() ? null : result.iterator().next();
    }

	/**
     * 存入Map
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}
