package com.maila.biz.center.api.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * 麦啦商品类型
 * <p>
 * ClassName:GoodsType
 * Date     : 2016年11月02日 17:57:24
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public enum MailaGoodsType {
	TAOBAO_ITEM_ID(1, "专享价"), URL(2, "优惠券"), CASH_ON_DELIVERY(3, "货到付款");

	private int id;
	private String name;

	MailaGoodsType(int id, String name) {
		this.id = id;
		this.name = name;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}


	/**
	 * 根据id获取名称
	 *
	 * @param id
	 * @return
	 */
	public static String getNameById(final int id) {
		Collection<MailaGoodsType> result = Collections2.filter(Arrays.asList(MailaGoodsType.values()), gs -> gs.getId() == id);
		return result.isEmpty() ? "" : result.iterator().next().getName();
	}

	/**
	 * 存入map
	 * @return
	 */
	@JsonValue
	public Map<String, Object> transform2Map() {
		Map<String, Object> map = new HashMap<>();
		map.put("name", getName());
		map.put("id", getId());
		return map;
	}

	/**
	 * 判断是否是已存在的GoodsPlanType
	 * @param id id
	 * @return
	 */
	public static boolean isGoodsPlanType(int id) {
		boolean flag =false;
		switch (id) {
			case 1:
			case 2:
				flag = true;
				break;
			default:
				break;
		}
		return flag;
	}
}

