package com.maila.biz.center.api.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * ClassName:MailaShopStatusType
 * Date     : 2016年12月06日 16:58:46
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public enum MailaShopAuditStatus {

    PENDING(0, "待审核"),
    UN_PASSED(1, "未通过"),
    PASSED(2, "审核通过");

    private int id;
    private String name;

    MailaShopAuditStatus(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    /**
     * 根据id获取名称
     *
     * @param id
     * @return
     */
    public static MailaShopAuditStatus getById(final int id) {
        Collection<MailaShopAuditStatus> result = Collections2.filter(Arrays.asList(MailaShopAuditStatus.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? null : result.iterator().next();
    }

	/**
     * 转换成map
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}
