package com.maila.biz.center.api.enums;

import java.util.Arrays;
import java.util.Collection;

import com.google.common.collect.Collections2;

/**
 * 麦啦商品库数据来源
 * @Author zhanghuifeng
 * @Date 11:07 2017/3/8
 */
public enum MailaSourceTypeEnum {
	OTHER(0,"其他"),
	DATAOKE(1,"大淘客"),
	QINGTAOKE(2,"轻淘客"),
	SUPER_FAN(3,"超级返"),
	FAN_LI_9K9(4,"返利9.9");

	private int id;
	private String name;

	MailaSourceTypeEnum(int id, String name){
		this.id = id;
		this.name = name;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	/**
	 * 根据id获取名称
	 *
	 * @param id
	 * @return
	 */
	public static String getNameById(final int id) {
		Collection<MailaSourceTypeEnum> result = Collections2.filter(Arrays.asList(MailaSourceTypeEnum.values()), gs -> gs.getId() == id);
		return result.isEmpty() ? "" : result.iterator().next().getName();
	}
}
