package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

import com.maila.biz.center.api.dto.MailaCategoryDto;

/**
 * 功能描述:
 *
 * @author sunchangji
 * @date 2017/1/20
 */
@AdvancedFeignClient
public interface RemoteMailaCategoryService {

	/**
	 * 查询全部分类信息的List集合
	 *
	 * @return DubboResult<List<MailaCategoryDto>>
	 */
	DubboResult<List<MailaCategoryDto>> selectAllCategoryList();

	/**
	 * 查询全部分类数据，map集合数据
	 *
	 * @return DubboResult<Map<Long,String>>
	 * key:类目id，value:类目名称
	 */
	DubboResult<Map<Integer, String>> selectAllCategoryMap();

	/**
	 * 更新类目tab标题
	 *
	 * @param id          类目id
	 * @param tabTitle    类目tab标题
	 * @return            成功/失败
	 */
	DubboResult<Boolean> updateCategoryTabTitle(Long id,String tabTitle);
}
