package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import com.maila.biz.center.api.dto.MailaMerchantsGoodsDto;

/**
 * 功能描述:麦啦商家商品接口类
 *
 * @author sunchangji
 * @date 2016/12/8
 */
@AdvancedFeignClient
public interface RemoteMailaMerchantsGoodsBackendService {

	/**
	 * 管理员后台商家商品审核
	 * @param mailaMerchantsGoodsDto 商家商品审核数据
	 * @return
	 */
	DubboResult<Boolean> audit(MailaMerchantsGoodsDto mailaMerchantsGoodsDto);

	/**
	 * 待审核商品中是否已存在有效期有冲突的商品
	 * @param itemId
	 * @param autoStartTime
	 * @param autoEndTime
	 * @return
	 */
	DubboResult<Boolean> isExistMerchantsGoods(Long itemId, Date autoStartTime, Date autoEndTime);
}
