package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaGoodsDto;

import java.util.List;

/**
 * Created by gyf .
 * 2017/2/15 .
 */
@AdvancedFeignClient
public interface RemoteRepairAssetsUrlBackendService {

    /**
     * 修复主商品库中的 url
     * http 的淘宝链接转成yun.duiba.com.cn
     * @return
     */
    DubboResult<List<MailaGoodsDto>> findBadImgUrlGoods();

    /**
     * 修复图片不正确的数据
     * @param goodsId
     * @param imgUrl
     * @return
     */
    DubboResult<Boolean> fixBadImgUrlGoods(Long goodsId, String imgUrl);

    /**
     * 修复双写的数据
     * @return
     */
    DubboResult<String> repaireDoubleWriteAppGoods();

    /**
     * 修复双写的数据
     * @return
     */
    DubboResult<String> repaireDoubleWriteGoods();
}
