package com.maila.biz.center.api.remoteservice.merchants.platform;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.maila.biz.center.api.dto.BusinessMsgDto;
import com.maila.biz.center.api.dto.merchants.Maila88MerchantsDto;
import com.maila.biz.center.api.enums.MailaEmailType;

/**
 * 商家端商家服务接口
 * Author: zhanghuifeng
 * Date:   15:56 2017/4/25
 */
@AdvancedFeignClient
public interface RemoteMaila88MerchantsService {

	/**
	 * 根据账号邮箱查找商家
	 *
	 * @param account  账号邮箱
	 * @return Maila88MerchantsDto
	 */
	DubboResult<Maila88MerchantsDto> findByAccount(String account);

	/**
	 * 更新商家
	 *
	 * @param mailaMerchantsDto 商家参数
	 * @return Boolean
	 */
	DubboResult<Boolean> updateMerchants(Maila88MerchantsDto mailaMerchantsDto);

	/**
	 * 商家注册
	 *
	 * @param mailaMerchantsDto 商家参数
	 * @return BusinessMsgDto
	 */
	DubboResult<BusinessMsgDto> signUp(Maila88MerchantsDto mailaMerchantsDto);

	/**
	 * 商家注册
	 *
	 * @param mailaMerchantsDto 商家参数
	 * @return BusinessMsgDto
	 */
	DubboResult<BusinessMsgDto> signUpWithVerifyStatus(Maila88MerchantsDto mailaMerchantsDto);

	/**
	 * 发送邮件
	 *
	 * @param account 商家账号邮箱
	 * @param type    商家账号类型 @See MailaEmailType
	 * @return BusinessMsgDto
	 */
	DubboResult<BusinessMsgDto> sendEmail(String account, MailaEmailType type);
}
