package com.maila.biz.center.api.remoteservice.skin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.skin.Maila88SkinMarketDto;
import com.maila.biz.center.api.dto.skin.Maila88SkinMarketSelectDto;
import com.maila.biz.center.api.enums.MailaSkinTypeEnum;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.app.dto.Maila88AppDto;
import com.maila88.modules.skin.enums.Maila88SKinTypeEnum;
import com.maila88.modules.special.dto.Maila88SpecialDto;

import java.util.List;

/**
 * Created by peanuthuang on 2017/4/20.
 */
@AdvancedFeignClient
public interface RemoteMaila88SkinMarketBackendService {

    /**
     * 添加皮肤
     *
     * @param mailaSkinMarketDto
     * @return
     */
    DubboResult<Long> insert(Maila88SkinMarketDto mailaSkinMarketDto);

    /**
     * 更新皮肤
     *
     * @param mailaSkinMarketDto
     * @return
     */
    DubboResult<Boolean> update(Maila88SkinMarketDto mailaSkinMarketDto);

    /**
     * 根据皮肤id查询皮肤全属性
     *
     * @param skinId    皮肤id
     * @return
     */
    DubboResult<Maila88SkinMarketDto> findById(Long skinId);

    /**
     * 根据皮肤类型查询皮肤列表,供下拉列表
     *
     * @param skinType    皮肤类型  {@link MailaSkinTypeEnum}
     * @return
     */
    DubboResult<List<Maila88SkinMarketSelectDto>> findBySkinType4Select(Integer skinType);

    /**
     * 分页查询皮肤
     *
     * @param name        皮肤名称
     * @param skinType    皮肤类型  {@link MailaSkinTypeEnum}
     * @param offset      偏移量
     * @param pageSize    每页大小
     * @return
     */
    DubboResult<Maila88PageDto<Maila88SkinMarketDto>> find4Page(String name, Integer skinType, Integer offset, Integer pageSize);

    /**
     * 删除皮肤
     * @param id
     * @return
     */
    DubboResult<Boolean> delete(Long id);

    /**
     * 更新皮肤 无redis
     *
     * @param mailaSkinMarketDto 皮肤参数
     * @return boolean
     */
    DubboResult<Boolean> update4Simple(Maila88SkinMarketDto mailaSkinMarketDto);

    /**
     * 根据皮肤类型获取皮肤
     * @param skinTypeEnum 皮肤类型
     * @return 集合
     */
    DubboResult<List<Maila88SkinMarketDto>> findBySkinType(Maila88SKinTypeEnum skinTypeEnum);

    /**
     * 获取依赖的 apps
     * @param skinId
     * @return
     */
    DubboResult<List<Maila88AppDto>> findRefApps(Long skinId);

    /**
     * 获取依赖的专场 s
     * @param skinId
     * @return
     */
    DubboResult<List<Maila88SpecialDto>> findRefSpecials(Long skinId);
}
