package com.maila88.common.dto;

import java.io.Serializable;

/**
 * 功能描述:用于传输携带错误消息提示
 *
 * @author sunchangji
 * @date 2016/11/9
 */
public class Maila88BusinessMsgDto<T extends Serializable> implements Serializable {
	private static final long serialVersionUID = 8465687053249796290L;

	/**
	 * 本次操作是否成功
	 */
	private Boolean success;

	/**
	 * 错误消息提示
	 */
	private String msg;

	/**
	 * 数据
	 */
	private T data;

	/**
	 * 成功信息设置
	 *
	 * @return BusinessMsgDto 消息实体类
	 */
	public static <T extends Serializable> Maila88BusinessMsgDto<T> successMsg() {
		Maila88BusinessMsgDto<T> errorMsgDto = new Maila88BusinessMsgDto<>();
		errorMsgDto.setSuccess(true);
		errorMsgDto.setMsg("操作成功");
		return errorMsgDto;
	}

	/**
	 * 成功数据设置
	 *
	 * @return BusinessMsgDto 消息实体类
	 */
	public static <T extends Serializable> Maila88BusinessMsgDto<T> successData(T data) {
		Maila88BusinessMsgDto<T> errorMsgDto = new Maila88BusinessMsgDto<>();
		errorMsgDto.setSuccess(true);
		errorMsgDto.setMsg("操作成功");
		errorMsgDto.setData(data);
		return errorMsgDto;
	}

	/**
	 * 业务失败消息实体类设置
	 * @param errorMsg 失败消息提示语
	 * @return BusinessMsgDto 消息实体类
	 */
	public static <T extends Serializable> Maila88BusinessMsgDto<T> failedMsg(String errorMsg) {
		Maila88BusinessMsgDto<T> errorMsgDto = new Maila88BusinessMsgDto<>();
		errorMsgDto.setSuccess(false);
		errorMsgDto.setMsg(errorMsg);
		return errorMsgDto;
	}

	public Boolean getSuccess() {
		return success;
	}

	public void setSuccess(Boolean success) {
		this.success = success;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}
}
