package com.maila88.common.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Collections2;
import com.maila.biz.center.api.enums.RelationType;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * 关联关系枚举类
 * <p>
 * Created by sunchangji on 2017/7/4.
 */
public enum Maila88RelationTypeEnum {
    URL(1, "url"),
    GOODS(2, "商品"),
    SPECIAL(3, "专场"),
    FIXED_IMAGE(4, "死图");

    private int id;
    private String name;

    Maila88RelationTypeEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }


    /**
     * 根据id获取名称
     *
     * @param id
     * @return
     */
    public static String getNameById(final int id) {
        Collection<RelationType> result = Collections2.filter(Arrays.asList(RelationType.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }

    /**
     * 转换成map
     *
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}
