package com.maila88.modules.app.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * 麦啦商品状态
 */
public enum Maila88AppEnableEnum {

    DISABLE(0, "禁用"),
    ENABLE(1, "启用");

    private int    value;
    private String name;

    Maila88AppEnableEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static Maila88AppEnableEnum getByValue(final int value) {
        Collection<Maila88AppEnableEnum> result = Collections2.filter(Arrays.asList(Maila88AppEnableEnum.values()), gs -> gs.getValue() == value);
        return result.isEmpty() ? null : result.iterator().next();
    }
}
