package com.maila88.modules.app.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.BusinessMsgDto;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.app.dto.Maila88AppDto;
import com.maila88.modules.app.dto.Maila88AppOSTypeHidDto;
import com.maila88.modules.app.dto.Maila88AppSelectDto;
import com.maila88.modules.app.dto.Maila88AppSkinInfoDto;
import com.maila88.modules.app.enums.Maila88AppEnableEnum;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * Created by peanuthuang on 2017/4/20.
 */
@AdvancedFeignClient
public interface RemoteMaila88AppBackendService {

    /**
     * 注册麦啦app
     *
     * @param mailaAppDto
     * @return
     */
    DubboResult<BusinessMsgDto> insert(Maila88AppDto mailaAppDto);

    /**
     * 更新麦啦app
     *
     * @param mailaAppDto
     * @return
     */
    DubboResult<BusinessMsgDto> update(Maila88AppDto mailaAppDto);


    /**
     * 根据id查询app
     *
     * @param appId
     * @return
     */
    DubboResult<Maila88AppDto> findById(Long appId);


    /**
     * 分页查找所有app
     *
     * @param name          应用名称
     * @param appId         应用id
     * @param currentPage
     * @param pageSize
     * @return
     */
    DubboResult<Maila88PageDto<Maila88AppDto>> find4Page(String name, Long appId, Integer enable, Integer currentPage, Integer pageSize);

    /**
     * 查找所有应用，供下拉列表
     *
     * @param appId  应用id
     * @param name   应用名称
     * @return
     */
    DubboResult<List<Maila88AppSelectDto>> find4Select(Long appId, String name);

    /**
     * 根据应用id获取应用皮肤信息
     *
     * @param appId   应用id
     * @return
     */
    DubboResult<Maila88AppSkinInfoDto> findSkinInfo(Long appId);

    /**
     * 更新应用皮肤信息
     *
     * @param appSkinInfoDto
     * @return
     */
    DubboResult<Boolean> updateSkinInfo(Maila88AppSkinInfoDto appSkinInfoDto);

    /**
     * 获取所有app信息
     * @return
     */
    DubboResult<List<Maila88AppDto>> getAllAppInfo();

    /**
     * 更变app configure 状态
     * @param index
     * @param status
     * @return
     */
    DubboResult<Boolean> updateAppConfiguration(Long appId, Integer index, Boolean status);

    /**
     * 根据pid查询应用id
     * @param pid
     * @return
     */
    DubboResult<List<Long>> findAppIdByPid(String pid);

    /**
     * 根据id或名称查询应用信息
     * @param idOrName id或name
     * @return 应用列表
     */
    @RequestMapping("find4Select1")
    DubboResult<List<Maila88AppSelectDto>> find4Select(String idOrName);


    /**
     * 需求：http://cf.dui88.com/pages/viewpage.action?pageId=5801745
     * 查询配置了货到付款的应用信息
     *
     * @return
     */
    DubboResult<List<Maila88AppOSTypeHidDto>> findAppOsTypeHid();

    /**
     * 更新启用状态
     * @param appId
     * @param enableEnum
     * @return
     */
    DubboResult<Boolean> changeEnable(Long appId, Maila88AppEnableEnum enableEnum);
}
