package com.maila88.modules.banner.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能描述:麦啦Banner详细的信息 包括相关联的商品或者专场的信息,用与管理端
 * Created by sunchangji on 2017/5/9.
 */
public class Maila88BannerBackendDto implements Serializable{
    private static final long serialVersionUID = 3211268619621233497L;

    /**
     * bannerId
     */
    private Long id;
    /**
     * 应用id
     */
    private Long appId;
    /**
     * Banner图
     */
    private String imgUrl;
    /**
     * 商品或者专场的id
     */
    private Long relationId;
    /**
     * Banner类型(1:URL,2:商品,3:专场)
     */
    private Integer relationType;
    /**
     * 根据relationType对应商品的名称或者专场名称
     */
    private String relationName;

    /**
     * 根据relationType对应商品的名称或者专场的状态
     */
    private Integer relationStatus;

    /**
     * 如果relationType为1(URL)类型，则对应该字段
     */
    private String url;
    /**
     * banner状态(1:启用,0:禁用)
     */
    private Integer enable;


    /**
     * 排序值
     */
    private Integer payload;

    /**
     * 自动启动时间
     */
    private Date autoStartTime;

    /**
     * 自动结束时间
     */
    private Date autoEndTime;

    /**
     * 开关
     */
    private Long switches;

    /**
     * 兑吧公共应用黑名单开关是否开启
     */
    private Boolean duibaBlacklistSwitch;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getEnable() {
        return enable;
    }

    public void setEnable(Integer enable) {
        this.enable = enable;
    }

    public String getRelationName() {
        return relationName;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public Date getAutoStartTime() {
        return autoStartTime;
    }

    public void setAutoStartTime(Date autoStartTime) {
        this.autoStartTime = autoStartTime;
    }

    public Date getAutoEndTime() {
        return autoEndTime;
    }

    public void setAutoEndTime(Date autoEndTime) {
        this.autoEndTime = autoEndTime;
    }

    public Integer getRelationStatus() {
        return relationStatus;
    }

    public void setRelationStatus(Integer relationStatus) {
        this.relationStatus = relationStatus;
    }

    public Long getSwitches() {
        return switches;
    }

    public void setSwitches(Long switches) {
        this.switches = switches;
    }

    public Boolean getDuibaBlacklistSwitch() {
        return duibaBlacklistSwitch;
    }

    public void setDuibaBlacklistSwitch(Boolean duibaBlacklistSwitch) {
        this.duibaBlacklistSwitch = duibaBlacklistSwitch;
    }

}
