package com.maila88.modules.discount.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.discount.dto.Maila88DiscountDto;
import com.maila88.modules.discount.param.Maila88DiscountQryParam;

import java.util.List;

/**
 * Created by sunchangji on 2017/5/15.
 */
@AdvancedFeignClient
public interface RemoteDiscountBackendService {

    /**
     * 批量新增所有应用记录,插入所有应用表中的对应的折扣值，如果存在不插入，不存在设置默认值
     *
     * @return
     */
    DubboResult<Boolean> batchInsert();

    /**
     * 更新折扣记录
     *
     * @param discountDto
     * @return
     */
    DubboResult<Boolean> update(Maila88DiscountDto discountDto);

    /**
     * 根据条件查询
     *
     * @param qryParam 查询参数
     * @return List<Maila88DiscountDto>
     */
    DubboResult<List<Maila88DiscountDto>> findConditionByPage(Maila88DiscountQryParam qryParam);

    /**
     * 根据条件查询总条数
     *
     * @param qryParam 查询参数
     * @return Integer
     */
    DubboResult<Integer> findCount(Maila88DiscountQryParam qryParam);
}
