package com.maila88.modules.goods.enums;

import java.util.Arrays;
import java.util.Collection;

import com.google.common.collect.Collections2;

/**
 * 商品异常类型
 * Author: zhanghuifeng
 * Date:   17:16 2017/6/27
 */
public enum Maila88AbnormalStatusEnum {

	PRICE_ABNORMAL(1,"商品价格变动");

	private int status;

	private String name;

	Maila88AbnormalStatusEnum(int status, String name){
		this.status = status;
		this.name = name;
	}
	public int getStatus() {
		return status;
	}

	public String getName() {
		return name;
	}

	public static String getNameByStatus(final int status) {
		Collection<Maila88AbnormalStatusEnum> result = Collections2.filter(Arrays.asList(Maila88AbnormalStatusEnum.values()), gs -> {
			assert gs != null;
			return gs.getStatus() == status;
		});
		return result.isEmpty() ? "" : result.iterator().next().getName();
	}
}
