package com.maila88.modules.goods.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.goods.dto.Maila88AppGoodsContentDto;
import com.maila88.modules.goods.dto.Maila88AppGoodsDto;
import com.maila88.modules.goods.dto.Maila88AppGoodsScheduledDto;
import com.maila88.modules.goods.dto.Maila88GoodsSelectDto;
import com.maila88.modules.goods.param.Maila88AppGoodsQryParam;

import java.util.Date;
import java.util.List;

/**
 * 管理员后台,已选商品的 service
 * Created by gyf .
 * 2017/6/6 .
 */
@AdvancedFeignClient
public interface RemoteMaila88AppGoodsBackendService {

    /**
     * 查询分页列表
     * @param maila88AppGoodsQryParam
     * @return
     */
    DubboResult<Maila88PageDto<Maila88AppGoodsDto>> findAppGoodsPage(Maila88AppGoodsQryParam maila88AppGoodsQryParam);

    /**
     * 更新个性化排期
     * @param scheduledDto
     * @return
     */
    DubboResult<Boolean> updateScheduled(Maila88AppGoodsScheduledDto scheduledDto);

    /**
     * 更新个性化内容
     * @param contentDto
     * @return
     */
    DubboResult<Boolean> updateContent(Maila88AppGoodsContentDto contentDto);

    /**
     * 商品进 tab
     * @param appId
     * @param goodsIds
     * @param tabIds
     * @return
     */
    DubboResult<Boolean> pushGoodsToTabs(Long appId, List<Long> goodsIds, List<Long> tabIds);

    /**
     * 批量改 角标
     * @param appId
     * @param goodsIds
     * @param cornerImgUrl
     * @return
     */
    DubboResult<Boolean> batchChangeCorner(Long appId, List<Long> goodsIds, String cornerImgUrl);

    /**
     * 批量排期
     * @param appId
     * @param goodsIds
     * @param startTime
     * @param endTime
     * @return
     */
    DubboResult<Boolean> batchSchedule(Long appId, List<Long> goodsIds, Date startTime, Date endTime);

    /**
     * 批量删除虚拟库
     * @param appId
     * @param goodsIds
     * @return
     */
    DubboResult<Boolean> batchDelete(Long appId, List<Long> goodsIds);

    /**
     * 查询选择的商品
     * @param appId
     * @param value
     * @return
     */
    DubboResult<List<Maila88GoodsSelectDto>> findSelectGoods(Long appId, String value);

    /**
     * 查询选择的商品分页
     * @param appId
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<List<Maila88GoodsSelectDto>> findSelectGoodsPage(Long appId, Integer offset, Integer pageSize);

}
