package com.maila88.modules.merchants.enums;

import java.util.Arrays;
import java.util.Collection;

import com.google.common.collect.Collections2;

/**
 * 商家账号激活状态
 * Author: zhanghuifeng
 * Date:   9:56 2017/6/21
 */
public enum Maila88VerifyStatusEnum {
	NOT_VERIFY(0,"未激活"),
	ALREADY_VERIFY(1,"已激活");

	private int status;

	private String name;

	Maila88VerifyStatusEnum(int status, String name){
		this.status = status;
		this.name = name;
	}

	public int getStatus() {
		return status;
	}

	public String getName() {
		return name;
	}

	/**
	 * 根据id获取名称
	 *
	 * @param id
	 * @return
	 */
	public static String getNameByStatus(final int id) {
		Collection<Maila88VerifyStatusEnum> result = Collections2.filter(Arrays.asList(Maila88VerifyStatusEnum.values()), gs -> gs.getStatus() == id);
		return result.isEmpty() ? "" : result.iterator().next().getName();
	}
}
