package com.maila88.modules.odps.enums;

import java.util.Arrays;
import java.util.List;

/**
 * Created by peanut.huang on 2017/7/14.
 */
public enum  Maila88AutoReportFileStatusEnum {

    READY(0,"初始未入库"),

    REPORTED(1,"已入库");


    private int id;

    private String name;

    Maila88AutoReportFileStatusEnum(int id, String name){
        this.id = id;
        this.name = name;
    }

    public static Maila88AutoReportFileStatusEnum findById(Integer id){
        if(id == null || id <= 0){
            return null;
        }

        List<Maila88AutoReportFileStatusEnum> enumList = Arrays.asList(Maila88AutoReportFileStatusEnum.values());

        return enumList.stream().filter(e -> e.getId() == id).findFirst().orElse(null);
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }
}
