package com.maila88.modules.odps.enums;

import java.util.Arrays;
import java.util.List;

/**
 * 报表类型
 * Created by peanut.huang on 2017/8/11.
 */
public enum Maila88AutoReportTypeEnum {

    DAILY(1,"日报"),

    MONTH(2,"月报");

    private int id;

    private String name;

    Maila88AutoReportTypeEnum(int id, String name){
        this.id = id;
        this.name = name;
    }

    /**
     * 根据id查询文件类型
     *
     * @param id
     * @return
     */
    public static Maila88AutoReportTypeEnum findById(Integer id){
        if(id == null || id <= 0){
            return null;
        }

        List<Maila88AutoReportTypeEnum> enumList = Arrays.asList(Maila88AutoReportTypeEnum.values());

        return enumList.stream().filter(e -> e.getId() == id).findFirst().orElse(null);
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }
}
