package com.maila88.modules.rob.dto;

import com.maila.biz.center.api.enums.MailaGoodsType;

import java.io.Serializable;
import java.util.Date;

/**
 * 抢购分页返回数据
 * Created by peanuthuang on 2017/5/4.
 */
public class Maila88RobGoodsPageDto implements Serializable {

    private static final long serialVersionUID = 7477186504042813166L;

    /**
     * 商品记录id
     */
    private Long id;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 场次id
     */
    private Long sceneId;

    /**
     * 管理后台显示商品名称
     */
    private String name4admin;

    /**
     * 优惠券详细信息链接地址
     **/
    private String  couponUrl;

    /**
     * 手机端显示商品名称
     */
    private String title;

    /**
     * 淘宝商品id
     */
    private Long itemId;

    /**
     * 商品类型:淘宝itemId,url {@link MailaGoodsType }
     */
    private Integer goodsType;

    /**
     * 商品内容，根据goodsType变化，itemId,URL @See MailaGoodsType
     */
    private String goodsContent;

    /**
     * 商品优惠价
     */
    private Integer preferPrice;

    /**
     * 商品图地址
     */
    private String imgUrl;

    /**
     * 商品状态:待上架，已上架，已下架 @See GoodsSpecialStatus
     */
    private Integer goodsStatus;

    /**
     * 自动启动时间
     */
    private Date autoStartTime;

    /**
     * 自动结束时间
     */
    private Date autoEndTime;

    /**
     * 抢购商品pv数
     */
    private Long goodsPv;

    /**
     * 抢购商品上限（售罄）pv数
     */
    private Long limitPv;

    /**
     * 抢购商品pv干扰值
     */
    private Long pvDisturbance;

    public String getCouponUrl() {
        return couponUrl;
    }

    public void setCouponUrl(String couponUrl) {
        this.couponUrl = couponUrl;
    }

    public Maila88RobGoodsPageDto() {
        super();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public String getName4admin() {
        return name4admin;
    }

    public void setName4admin(String name4admin) {
        this.name4admin = name4admin;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    public String getGoodsContent() {
        return goodsContent;
    }

    public void setGoodsContent(String goodsContent) {
        this.goodsContent = goodsContent;
    }

    public Integer getPreferPrice() {
        return preferPrice;
    }

    public void setPreferPrice(Integer preferPrice) {
        this.preferPrice = preferPrice;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getGoodsStatus() {
        return goodsStatus;
    }

    public void setGoodsStatus(Integer goodsStatus) {
        this.goodsStatus = goodsStatus;
    }

    public Date getAutoStartTime() {
        return autoStartTime;
    }

    public void setAutoStartTime(Date autoStartTime) {
        this.autoStartTime = autoStartTime;
    }

    public Date getAutoEndTime() {
        return autoEndTime;
    }

    public void setAutoEndTime(Date autoEndTime) {
        this.autoEndTime = autoEndTime;
    }

    public Long getGoodsPv() {
        return goodsPv;
    }

    public void setGoodsPv(Long goodsPv) {
        this.goodsPv = goodsPv;
    }

    public Long getLimitPv() {
        return limitPv;
    }

    public void setLimitPv(Long limitPv) {
        this.limitPv = limitPv;
    }

    public Long getPvDisturbance() {
        return pvDisturbance;
    }

    public void setPvDisturbance(Long pvDisturbance) {
        this.pvDisturbance = pvDisturbance;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }
}
