package com.maila88.modules.rob.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by peanuthuang on 2017/5/4.
 */
public enum Maila88SceneStatusEnum {

    READY(0, "待生效"),
    VALID(1, "已生效"),
    INVALID(-1, "已失效");

    private int id;
    private String name;

    Maila88SceneStatusEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static String getById(final int id) {
        Collection<Maila88SceneStatusEnum> result = Collections2.filter(Arrays.asList(Maila88SceneStatusEnum.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }
}
