package com.maila88.modules.special.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.special.dto.Maila88AppSpecialDto;
import com.maila88.modules.special.dto.Maila88AppSpecialSimpleDto;
import com.maila88.modules.special.params.Maila88AppSpecialQryParam;

import java.util.Date;
import java.util.List;

/**
 * Created by sunchangji on 2017/6/30.
 */
@AdvancedFeignClient
public interface RemoteMaila88AppSpecialBackendService {

    /**
     * 分页查询应用专场虚拟库
     *
     * @param appSpecialQryParam
     * @return
     */
    DubboResult<Maila88PageDto<Maila88AppSpecialDto>> findAppSpecials(Maila88AppSpecialQryParam appSpecialQryParam);

    /**
     * 应用专场虚拟库排期
     *
     * @param appId             应用id
     * @param specialId         专场id
     * @param scheduleStartTime 排期时间起
     * @param scheduleEndTime   排期时间止
     * @return
     */
    DubboResult<Boolean> appSpecialSchedule(Long appId, Long specialId, Date scheduleStartTime, Date scheduleEndTime);

    /**
     * 应用专场虚拟库进tab
     *
     * @param appId     应用id
     * @param specialId 专场id
     * @param tabIds    应用tab id集
     * @return
     */
    DubboResult<Boolean> appSpecialIntoTab(Long appId, Long specialId, List<Long> tabIds);


    /**
     * 移除应用虚拟专场
     *
     * @param appId      应用id
     * @param specialIds 专场id集
     * @return
     */
    DubboResult<Boolean> deleteAppSpecial(Long appId, List<Long> specialIds);

    /**
     * 根据专场名称或专场id查询专场信息
     * @param appId 应用id
     * @param nameOrId 专场名称或专场id
     * @return
     */
    DubboResult<List<Maila88AppSpecialSimpleDto>> findByNameOrId(Long appId, String nameOrId);

    /**
     * 查询待生效和生效中专场集合
     * @param appId
     * @return
     */
    DubboResult<List<Maila88AppSpecialSimpleDto>> findAppSpecialByAppId(Long appId);
}
