package com.maila88.modules.statistics.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.modules.statistics.dto.Maila88PersonasDto;

import java.util.List;

/**
 * Created by sunchangji on 2017/10/25.
 */
@AdvancedFeignClient
public interface RemoteMaila88PersonasService {

    /**
     * 根据开发者id和开发者接入用户id集合查询用户画像数据
     *
     * @param devId   麦啦开发者id
     * @param uidList 对接的开发者用户id集合
     * @return
     */
    List<Maila88PersonasDto> findByDevIdAndInUids(Long devId, List<String> uidList);

    /**
     * 根据开发者id和开发者接入用户id集合查询用户画像数据
     *
     * @param devId   麦啦开发者id
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<Maila88PersonasDto> findPageByDevId(Long devId, Integer pageNo, Integer pageSize);

    /**

     * 查询开发者下用户画像总条数
     * @param devId
     * @return
     */
    int countByDevId(Long devId);
}
