package com.maila88.modules.tab.enums;

import java.util.Arrays;
import java.util.List;

/**
 * Created by peanuthuang on 2017/6/19.
 */
public enum Maila88PublicTabContentEnum {

    GOODS(2, "商品"),
    SPECIAL(3, "专场");

    private int id;
    private String desc;

    Maila88PublicTabContentEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    /**
     * 根据id获取内容
     *
     * @param id
     * @return
     */
   public static Maila88PublicTabContentEnum findById(Integer id){
        if(id == null){
            return null;
        }
        List<Maila88PublicTabContentEnum> contentEnumList = Arrays.asList(Maila88PublicTabContentEnum.values());

        return contentEnumList.stream().filter(e->e.getId() == id).findFirst().orElse(null);
    }

    public int getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }

}
