package com.maila88.modules.tab.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88PageMoreDto;
import com.maila88.modules.tab.dto.Maila88PublicTabContentDto;
import com.maila88.modules.tab.dto.Maila88PublicTabContentRelationDto;
import com.maila88.modules.tab.dto.Maila88PublicTabSortContentDto;

import java.util.List;

/**
 * 公共tab内容服务
 *
 * Created by peanut.huang on 2017/6/21.
 */
@AdvancedFeignClient
public interface RemoteMaila88PublicTabContentBackendService {

    /**
     * 批量添加商品到公共tab
     *
     * @param publicTabId 公共tabId
     * @param goodsIds    商品id集合
     * @return
     */
    DubboResult<Boolean> batchInsertGoods(Long publicTabId, List<Long> goodsIds);

    /**
     * 批量添加专场到公共tab
     *
     * @param publicTabId 公共tabId
     * @param specialIds    专场id集合
     * @return
     */
    DubboResult<Boolean> batchInsertSpecials(Long publicTabId, List<Long> specialIds);

    /**
     * 公共tab内容列表
     *
     * @param publicTabId    公共tabId
     * @param appId          应用id
     * @param id             分页内容记录id
     * @param pageSize       每页条数
     * @return
     */
    DubboResult<List<Maila88PublicTabContentDto>> listPageContent(Long publicTabId, Long appId, Long id, Integer pageSize);

    /**
     * 公共tab内容列表
     *
     * @param publicTabId    公共tabId
     * @param appId          应用id
     * @param pageStart      分页开始页
     * @return
     */
    DubboResult<Maila88PageMoreDto<Maila88PublicTabSortContentDto>> newListPageContent(Long publicTabId, Long appId, Integer pageStart);


    /**
     * 移除公共tab内容
     *
     * @param publicTabId    公共tabId
     * @param relationId     内容id
     * @param relationType   内容类型
     * @return
     */
    DubboResult<Boolean> removeContent(Long publicTabId, Long relationId, Integer relationType);

    /**
     * 移除公共tab中已失效的内容
     *
     * @param publicTabId  公共tabId
     * @return
     */
    DubboResult<Boolean> removeInvalidContent(Long publicTabId);

    /**
     * 公共tab内容排序
     *
     * @param publicTabId  公共tabId
     * @param relationList
     * @return
     */
    DubboResult<Boolean> sortContent(Long publicTabId,List<Maila88PublicTabContentRelationDto> relationList );
}
