package com.maila88.modules.tab.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.TodayRobTabContentDto;

import java.util.List;

/**
 * Created by sunchangji on 2017/6/12.
 */
@AdvancedFeignClient
public interface RemoteMaila88TodayRobService {

    /**
     * 获取今日必砍的 tab 内容
     *
     * @param mailaAppId
     * @param mailaDeveloperId
     * @param duibaAppId
     * @param tabId
     * @param pageStart
     * @param pageSize
     * @return
     */
    DubboResult<List<TodayRobTabContentDto>> findTodayRobTabContent(Long mailaAppId, Long mailaDeveloperId, Long duibaAppId, Long tabId, Integer pageStart, Integer pageSize);

    /**
     * 获取今日必抢类目tab下的商品内容
     *
     * @param mailaAppId
     * @param mailaDeveloperId
     * @param duibaAppId
     * @param recordId           当前页第后一条商品的记录id
     * @param tabId
     * @param pageSize
     * @return
     */
    DubboResult<List<TodayRobTabContentDto>> findTodayRobCategoryTabContent(Long mailaAppId, Long mailaDeveloperId, Long duibaAppId, Long recordId, Long tabId, Integer pageSize);
}
