package com.maila88.modules.tag.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88BusinessMsgDto;
import com.maila88.modules.tag.dto.Maila88TagTypeDto;

import java.util.List;

/**
 * 麦啦标签类型后台服务
 *
 * Created by peanut.huang on 2017/8/18.
 */
@AdvancedFeignClient
public interface RemoteMaila88TagTypeBackendService {

    /**
     * 添加标签类别
     *
     * @param tagTypeDto
     * @return
     */
    DubboResult<Maila88BusinessMsgDto> insert(Maila88TagTypeDto tagTypeDto);

    /**
     * 更新标签类别
     *
     * @param tagTypeDto
     * @return
     */
    DubboResult<Maila88BusinessMsgDto> update(Maila88TagTypeDto tagTypeDto);

    /**
     * 更新标签类别
     *
     * @param typeId
     * @return
     */
    DubboResult<Boolean> delete(Long typeId);

    /**
     * 标签类别列表
     *
     * @return
     */
    DubboResult<List<Maila88TagTypeDto>> findList();
}
