package com.maila88.modules.user.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.user.dto.Maila88ConsumerDto;
import com.maila88.modules.user.dto.Maila88ConsumerExtendDto;
import com.maila88.modules.user.param.Maila88ConsumerExtendQryParam;

import java.util.Map;

/**
 * Created by gyf .
 * 2017/8/8 .
 */
@AdvancedFeignClient
public interface RemoteMaila88ConsumerService {

    /**
     * 保存或者获取
     * @param appId
     * @param partnerUid
     * @return
     */
    DubboResult<Maila88ConsumerDto> saveAndFind(Long appId, String partnerUid, Map<String, Object> extendParam);

    /**
     * 根据consumerId查询用户信息（deviceid 和taobaoUsernick）
     * @param consumerId
     * @return
     */
    DubboResult<Maila88ConsumerExtendDto> findConsumerExtendByConsumerId(Long consumerId);

    /**
     * 保存用户设备信息和taobao信息
     * @param params
     * @return
     */
    DubboResult<Boolean> saveExtendInfo(Maila88ConsumerExtendQryParam params);
}
