/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.response;

import com.mks.api.IntegrationPointFactory;
import com.mks.api.response.APIError;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.util.MKSLogger;
import java.text.MessageFormat;

public class APIExceptionFactory {
    private static final String EXCEPTION_CLASS_PREFIX = "com.mks.api.response.";
    private static final String UNKNOWN_EXCEPTION_CLASS_MSG = "Unknown exception class: {0}";
    private static final String EXCEPTION_CLASS_CONSTRUCTION_ERROR_MSG = "Error creating the exception object for: {0}";

    public static APIException createAPIException(String className, Response response) {
        APIException apiException = null;
        Object obj = APIExceptionFactory.getAPIExceptionObject(className);
        if (obj instanceof APIError) {
            APIError err = (APIError)obj;
            throw err;
        }
        apiException = (APIException)obj;
        apiException.setResponse(response);
        return apiException;
    }

    public static APIException createAPIException(String className, String msg) {
        Object obj = APIExceptionFactory.getAPIExceptionObject(className);
        if (obj instanceof APIError) {
            APIError err = (APIError)obj;
            err.setMessage(msg);
            throw err;
        }
        APIException apiException = (APIException)obj;
        apiException.setMessage(msg);
        return apiException;
    }

    private static APIException handleException(String msgKey, String className, Exception ex) {
        String logMsg = MessageFormat.format(msgKey, className);
        MKSLogger apiLogger = IntegrationPointFactory.getLogger();
        apiLogger.message(APIExceptionFactory.class, "API", 0, logMsg);
        apiLogger.exception(APIExceptionFactory.class, "API", 0, (Throwable)ex);
        APIException apiException = new APIException();
        apiException.addField("original-exception", EXCEPTION_CLASS_PREFIX + className);
        apiException.setMessage(ex.getMessage());
        return apiException;
    }

    private static Object getAPIExceptionObject(String className) {
        APIException obj = null;
        try {
            Class<?> clazz = Class.forName(EXCEPTION_CLASS_PREFIX + className);
            obj = clazz.newInstance();
            if (obj instanceof APIError) {
                APIError err = (APIError)((Object)obj);
                err.setShowStackTrace(false);
            } else {
                APIException apiException = obj;
                apiException.setShowStackTrace(false);
            }
        }
        catch (ClassNotFoundException ex) {
            obj = APIExceptionFactory.handleException(UNKNOWN_EXCEPTION_CLASS_MSG, className, ex);
        }
        catch (InstantiationException ex) {
            obj = APIExceptionFactory.handleException(EXCEPTION_CLASS_CONSTRUCTION_ERROR_MSG, className, ex);
        }
        catch (IllegalAccessException ex) {
            obj = APIExceptionFactory.handleException(EXCEPTION_CLASS_CONSTRUCTION_ERROR_MSG, className, ex);
        }
        catch (Exception ex) {
            obj = APIExceptionFactory.handleException(UNKNOWN_EXCEPTION_CLASS_MSG, className, ex);
        }
        return obj;
    }
}

