/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util.type;

import com.moilioncircle.redis.replicator.util.Iterators;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public class Tuple2<T1, T2>
implements Iterable<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private T1 v1;
    private T2 v2;

    public Tuple2() {
    }

    public Tuple2(T1 v1, T2 v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    public Tuple2(Tuple2<T1, T2> rhs) {
        this.v1 = rhs.getV1();
        this.v2 = rhs.getV2();
    }

    public T1 getV1() {
        return this.v1;
    }

    public T2 getV2() {
        return this.v2;
    }

    public void setV1(T1 v1) {
        this.v1 = v1;
    }

    public void setV2(T2 v2) {
        this.v2 = v2;
    }

    public <V1, V2> Tuple2<V1, V2> map(Function<Tuple2<T1, T2>, Tuple2<V1, V2>> function) {
        return function.apply(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple2 tuple2 = (Tuple2)o;
        if (this.v1 != null ? !this.v1.equals(tuple2.v1) : tuple2.v1 != null) {
            return false;
        }
        return this.v2 != null ? this.v2.equals(tuple2.v2) : tuple2.v2 == null;
    }

    public int hashCode() {
        int result = this.v1 != null ? this.v1.hashCode() : 0;
        result = 31 * result + (this.v2 != null ? this.v2.hashCode() : 0);
        return result;
    }

    @Override
    public Iterator<Object> iterator() {
        return Iterators.iterator(this.getV1(), this.getV2());
    }

    public String toString() {
        return "[" + this.v1 + ", " + this.v2 + "]";
    }

    public static <V> Tuple2<V, V> from(V ... ary) {
        if (ary == null || ary.length != 2) {
            throw new IllegalArgumentException();
        }
        return new Tuple2<V, V>(ary[0], ary[1]);
    }

    public static <V> Tuple2<V, V> from(Iterator<V> iterator) {
        ArrayList<V> list = new ArrayList<V>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return Tuple2.from(list.toArray(new Object[list.size()]));
    }

    public static <V> Tuple2<V, V> from(Iterable<V> iterable) {
        return Tuple2.from(iterable.iterator());
    }

    public static <V> Tuple2<V, V> from(Collection<V> collection) {
        return Tuple2.from(collection);
    }

    public Object[] toArray() {
        return new Object[]{this.getV1(), this.getV2()};
    }

    public <T> T[] toArray(Class<T> clazz) {
        Object[] ary = (Object[])Array.newInstance(clazz, 5);
        if (!clazz.isInstance(this.getV1())) {
            throw new UnsupportedOperationException();
        }
        ary[0] = this.getV1();
        if (!clazz.isInstance(this.getV2())) {
            throw new UnsupportedOperationException();
        }
        ary[1] = this.getV2();
        return ary;
    }

    public <T> T toObject(Function<Tuple2<T1, T2>, T> func) {
        return func.apply(this);
    }
}

